int pinEN = 11;
int pin1A = 9;
int pin2A = 10;

int delayPWM = 50;
int delaySTEP = 5;

int delayMIN = 5;
int delayMAX = 50;

int dir = -1;

int stepPWM = 10;

void setup() {
  
  pinMode(pin1A, OUTPUT);
  pinMode(pin2A, OUTPUT);
  
  digitalWrite(pin1A, LOW);
  digitalWrite(pin2A, LOW);
  
}

void loop() {

  digitalWrite(pin1A, LOW);
  digitalWrite(pin2A, HIGH);

  moveHalfCycle();
  
  digitalWrite(pin1A, HIGH);
  digitalWrite(pin2A, LOW);

  moveHalfCycle();

  delayPWM += dir*delaySTEP;

  if (delayPWM <= delayMIN) dir = 1;
  if (delayPWM >= delayMAX) dir = -1;
  
}

void moveHalfCycle() {

  for (int i=0; i<256; i+=stepPWM) {
    analogWrite(pinEN, i);
    delay(delayPWM);
  }

  for (int i=255; i>=0; i-=stepPWM) {
    analogWrite(pinEN, i);
    delay(delayPWM);
  }
  
}
