int pinPote = A5;
int pinMotor = 9;
int pinInterrupt = 2;

int valPWM;

int interruptsRev = 1;    // Número interrupciones por cada rotación completa

float rpmMax = 600;
float rpm = 0;

volatile unsigned long reftimeT = millis();       // Modificado en la interrupción
volatile unsigned long T = 1;                     // T es el tiempo entre interrupciones -> Modificado en la interrupción
                                                  // (T * interruptsRev) es el período de rotación 

unsigned long reftimePrint = millis();
unsigned long intervalPrint = 250;

void setup() {

  Serial.begin(9600);

  pinMode(pinMotor, OUTPUT);
  pinMode(pinInterrupt, INPUT);

  // attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, RISING);  // Interrupción 0: Pin 2 Arduino Uno, Pin 3 Arduino Leonardo
  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, FALLING);
  //  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, CHANGE);
  //  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, LOW);
  
}

void loop() {

  valPWM = map(analogRead(pinPote), 0, 1023, 0, 255);
  analogWrite(pinMotor, valPWM);

  if (millis() - reftimePrint >= intervalPrint) {
    rpm = 60000.0 / (T * interruptsRev);
    if (rpm < rpmMax) {
      Serial.print("RPM: ");
      Serial.println(rpm);      
    }  
    reftimePrint = millis();
  }

}

void detectarEvento() {
  unsigned long now = millis();
  T = now - reftimeT;
  reftimeT = now;
}
