int pins[] = {8, 9, 10, 11};  // Motor pins
int npins = 4;

int nsteps = 8;

// Full-step (wave drive)
int steps[8][4] = {
      {1, 0, 0, 0},
      {0, 1, 0, 0},
      {0, 0, 1, 0},
      {0, 0, 0, 1},
      {1, 0, 0, 0},
      {0, 1, 0, 0},
      {0, 0, 1, 0},
      {0, 0, 0, 1}
    };

// Alternate Full-step 
//int steps[8][4] = {
//      {1, 0, 0, 1},
//      {1, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 1},
//      {1, 0, 0, 1},
//      {1, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 1}
//    };

// Half-step 
//int steps[8][4] = {
//      {1, 0, 0, 0},
//      {1, 1, 0, 0},
//      {0, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 0},
//      {0, 0, 1, 1},
//      {0, 0, 0, 1},
//      {1, 0, 0, 1}
//    };

int n = 0;
unsigned long delaystep = 100;
unsigned long reftime = millis();

int pinPote = A5;
int valPote;

void setup() {
  
  for (int i = 0; i < npins; i++) {
    pinMode(pins[i], OUTPUT);
    digitalWrite(pins[i], LOW);
  }
  
}

void loop() {

  valPote = analogRead(pinPote);
  delaystep = map(valPote,0,1023,1000,10);

  if (millis()-reftime >= delaystep) {
    stepMotor(n);
    n++;
    if (n >= nsteps) {
      n = 0;
    }
    reftime = millis();   
  }
  
}

void stepMotor(int s) {
  
  for (int i = 0; i < npins; i++) {
    digitalWrite(pins[i], steps[s][i]);
  }
  
}
