int pins[] = {8, 9, 10, 11};  // Motor pins
int npins = 4;

int nsteps = 8;

// Full-step (wave drive)
int steps[8][4] = {
      {1, 0, 0, 0},
      {0, 1, 0, 0},
      {0, 0, 1, 0},
      {0, 0, 0, 1},
      {1, 0, 0, 0},
      {0, 1, 0, 0},
      {0, 0, 1, 0},
      {0, 0, 0, 1}
    };

// Alternate Full-step 
//int steps[8][4] = {
//      {1, 0, 0, 1},
//      {1, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 1},
//      {1, 0, 0, 1},
//      {1, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 1}
//    };

// Half-step 
//int steps[8][4] = {
//      {1, 0, 0, 0},
//      {1, 1, 0, 0},
//      {0, 1, 0, 0},
//      {0, 1, 1, 0},
//      {0, 0, 1, 0},
//      {0, 0, 1, 1},
//      {0, 0, 0, 1},
//      {1, 0, 0, 1}
//    };

int n = 0;

void setup() {
  
  for (int i = 0; i < npins; i++) {
    pinMode(pins[i], OUTPUT);
    digitalWrite(pins[i], LOW);
  }
  
}

void loop() {
    
  mover(100, 50);
  delay(1000);
  mover(50, 10);
  delay(1000);
  mover(-100, 30);
  delay(1000);
  
}

void stepMotor(int s) {
  
  for (int i = 0; i < npins; i++) {
    digitalWrite(pins[i], steps[s][i]);
  }
  
}

void mover(int numSteps, int delaystep) {
  
  if (numSteps >= 0) {
    forward(numSteps, delaystep);
  } else {
    backward(abs(numSteps), delaystep);
  }
  
}

void forward(int numSteps, int delaystep) {
  
  for (int i = 0; i < numSteps; i++) {
    stepMotor(n);
    delay(delaystep);
    n++;
    if (n >= nsteps) {
      n = 0;
    }
  }
  
}

void backward(int numSteps, int delaystep) {
  
  for (int i = 0; i < numSteps; i++) {
    stepMotor(n);
    delay(delaystep);
    n--;
    if (n < 0) {
      n = nsteps - 1;
    }
  }
  
}
